/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.nio;

import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.glassfish.grizzly.ThreadCache;
import org.glassfish.grizzly.memory.Buffers;

public final class DirectByteBufferRecord {
    private static final ThreadCache.CachedTypeIndex<DirectByteBufferRecord> CACHE_IDX = ThreadCache.obtainIndex("direct-buffer-cache", DirectByteBufferRecord.class, 1);
    private ByteBuffer directBuffer;
    private int sliceOffset;
    private ByteBuffer directBufferSlice;
    private SoftReference<ByteBuffer> softRef;
    private ByteBuffer[] array = new ByteBuffer[8];
    private int arraySize;

    public static DirectByteBufferRecord get() {
        DirectByteBufferRecord record2 = ThreadCache.getFromCache(CACHE_IDX);
        if (record2 != null) {
            return record2;
        }
        DirectByteBufferRecord recordLocal = new DirectByteBufferRecord();
        ThreadCache.putToCache(CACHE_IDX, recordLocal);
        return recordLocal;
    }

    DirectByteBufferRecord() {
    }

    public ByteBuffer getDirectBuffer() {
        return this.directBuffer;
    }

    public ByteBuffer getDirectBufferSlice() {
        return this.directBufferSlice;
    }

    public ByteBuffer allocate(int size2) {
        ByteBuffer byteBuffer = this.switchToStrong();
        if (byteBuffer != null && byteBuffer.remaining() >= size2) {
            return byteBuffer;
        }
        byteBuffer = ByteBuffer.allocateDirect(size2);
        this.reset(byteBuffer);
        return byteBuffer;
    }

    public ByteBuffer sliceBuffer() {
        int oldLim = this.directBuffer.limit();
        Buffers.setPositionLimit(this.directBuffer, this.sliceOffset, this.directBuffer.capacity());
        this.directBufferSlice = this.directBuffer.slice();
        Buffers.setPositionLimit(this.directBuffer, 0, oldLim);
        return this.directBufferSlice;
    }

    public void finishBufferSlice() {
        if (this.directBufferSlice != null) {
            this.directBufferSlice.flip();
            this.sliceOffset += this.directBufferSlice.remaining();
            this.directBufferSlice = null;
        }
    }

    public ByteBuffer[] getArray() {
        return this.array;
    }

    public int getArraySize() {
        return this.arraySize;
    }

    public void putToArray(ByteBuffer byteBuffer) {
        this.ensureArraySize();
        this.array[this.arraySize++] = byteBuffer;
    }

    public void release() {
        if (this.directBuffer != null) {
            this.directBuffer.clear();
            this.switchToSoft();
        }
        Arrays.fill(this.array, 0, this.arraySize, null);
        this.arraySize = 0;
        this.directBufferSlice = null;
        this.sliceOffset = 0;
    }

    ByteBuffer switchToStrong() {
        if (this.directBuffer == null && this.softRef != null) {
            this.directBuffer = this.directBufferSlice = this.softRef.get();
        }
        return this.directBuffer;
    }

    void switchToSoft() {
        if (this.directBuffer != null && this.softRef == null) {
            this.softRef = new SoftReference<ByteBuffer>(this.directBuffer);
        }
        this.directBuffer = null;
    }

    void reset(ByteBuffer byteBuffer) {
        this.directBuffer = this.directBufferSlice = byteBuffer;
        this.softRef = null;
    }

    private void ensureArraySize() {
        if (this.arraySize == this.array.length) {
            this.array = Arrays.copyOf(this.array, this.arraySize * 3 / 2 + 1);
        }
    }
}

